(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     15143,        492]
NotebookOptionsPosition[     14166,        460]
NotebookOutlinePosition[     14509,        475]
CellTagsIndexPosition[     14466,        472]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Undamped", " ", "Motion"}], "*)"}]], "Input",
 CellChangeTimes->{{3.7009243489511223`*^9, 3.700924354739731*^9}, {
  3.700924593181369*^9, 3.700924603677297*^9}}],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"15", 
     RowBox[{"Cos", "[", 
      RowBox[{"3", "t"}], "]"}]}], "+", 
    RowBox[{"3", 
     RowBox[{"Sin", "[", 
      RowBox[{"3", "t"}], "]"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.700924370883898*^9, 3.7009243934440727`*^9}, {
   3.7009244306445947`*^9, 3.700924513376667*^9}, 3.7009246102148647`*^9, {
   3.7009250481145754`*^9, 3.7009250540023403`*^9}}],

Cell[BoxData[
 RowBox[{"StreamPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{
      RowBox[{"-", "9"}], "y"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.70087308774429*^9, 3.7008730912615924`*^9}, {
  3.7008732252669277`*^9, 3.7008732898507776`*^9}, {3.700873449755081*^9, 
  3.700873459908964*^9}, {3.7008737441222925`*^9, 3.700873748244029*^9}, {
  3.700924297866782*^9, 3.70092436119586*^9}}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Underdamped", " ", "Motion"}], "*)"}]], "Input",
 CellChangeTimes->{{3.7009246274030943`*^9, 3.700924631494486*^9}}],

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"\[ExponentialE]", "^", 
         RowBox[{"(", 
          RowBox[{"-", "t"}], ")"}]}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"3", "/", "2"}], ")"}], 
           RowBox[{"Cos", "[", 
            RowBox[{"3", "t", 
             RowBox[{"\[Sqrt]", 
              RowBox[{"(", "7", ")"}]}]}], "]"}]}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "/", 
             RowBox[{"(", 
              RowBox[{"2", 
               RowBox[{"\[Sqrt]", 
                RowBox[{"(", "7", ")"}]}]}], ")"}]}], ")"}], 
           RowBox[{"Sin", "[", 
            RowBox[{"3", "t", 
             RowBox[{"\[Sqrt]", 
              RowBox[{"(", "7", ")"}]}]}], "]"}]}]}], ")"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"3", "\[Pi]"}]}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", 
            RowBox[{"3", "\[Pi]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1.7"}], ",", "1.7"}], "}"}]}], "}"}]}]}], "]"}], 
     ",", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"4", "/", 
          RowBox[{"\[Sqrt]", 
           RowBox[{"(", "7", ")"}]}]}], ")"}], 
        RowBox[{"\[ExponentialE]", "^", 
         RowBox[{"(", 
          RowBox[{"-", "t"}], ")"}]}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Red", ",", 
          RowBox[{"Opacity", "[", "O", "]"}]}], "}"}]}]}], "]"}], ",", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{"4", "/", 
           RowBox[{"\[Sqrt]", 
            RowBox[{"(", "7", ")"}]}]}], ")"}]}], 
        RowBox[{"\[ExponentialE]", "^", 
         RowBox[{"(", 
          RowBox[{"-", "t"}], ")"}]}]}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"3", "\[Pi]"}]}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Red", ",", 
          RowBox[{"Opacity", "[", "O", "]"}]}], "}"}]}]}], "]"}]}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"O", ",", "0", ",", "\"\<Show Amplitude Limits\>\""}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.700924646304268*^9, 3.70092470345884*^9}, {
  3.7009247711778564`*^9, 3.7009248293710637`*^9}, {3.700924955123598*^9, 
  3.70092495736564*^9}}],

Cell[BoxData[
 RowBox[{"StreamPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{
      RowBox[{"-", "y"}], "-", "v"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.700873462977775*^9, 3.700873525568306*^9}, {
  3.7008737507082896`*^9, 3.7008737541112556`*^9}, {3.700924619541076*^9, 
  3.700924640437954*^9}}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Overdamped", " ", "Motion"}], "*)"}]], "Input"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"17", "/", "12"}], ")"}], 
     RowBox[{"\[ExponentialE]", "^", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "4"}], "t"}], ")"}]}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"5", "/", "12"}], ")"}], 
     RowBox[{"\[ExponentialE]", "^", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "16"}], "t"}], ")"}]}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "3"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1.5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1.1"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.700925330844863*^9, 3.7009254509894447`*^9}}],

Cell[BoxData[
 RowBox[{"StreamPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "64"}], "y"}], "-", 
      RowBox[{"20", "v"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.700873598997757*^9, 3.7008736100620747`*^9}, {
  3.700873755508097*^9, 3.7008737562498655`*^9}, {3.700925324932438*^9, 
  3.7009253261635413`*^9}, {3.700925482742504*^9, 3.7009254923252754`*^9}}],

Cell[BoxData[
 RowBox[{"StreamPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{
      RowBox[{"-", "y"}], "-", 
      RowBox[{"3", "v"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Critcally", " ", "Damped", " ", "Motion"}], "*)"}]], "Input"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"\[ExponentialE]", "^", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "8"}], "t"}], ")"}]}], 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"28", "t"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1.2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "2"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7009256249974117`*^9, 3.7009256672520494`*^9}}],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"\[ExponentialE]", "^", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "8"}], "t"}], ")"}]}], 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"12", "t"}]}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1.2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.6"}], ",", "1.1"}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.700925737242175*^9, 3.7009257596499166`*^9}}],

Cell[BoxData[
 RowBox[{"StreamPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "64"}], "y"}], "-", 
      RowBox[{"16", "v"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7009256874492273`*^9, 3.7009256970663033`*^9}}],

Cell[BoxData[
 RowBox[{"StreamPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{
      RowBox[{"-", "y"}], "-", 
      RowBox[{"2", "v"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.70087363922918*^9, 3.700873648629282*^9}, {
  3.700873757924048*^9, 3.7008737587841854`*^9}, {3.700925538480338*^9, 
  3.7009255430308757`*^9}, {3.7009256803480606`*^9, 3.7009256828746023`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Undamped", " ", "Pendulum"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"StreamPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"v", ",", 
      RowBox[{
       RowBox[{"-", "9.8"}], 
       RowBox[{"Sin", "[", "y", "]"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"v", ",", 
      RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
    RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7008745734855576`*^9, 3.7008746276903725`*^9}}],

Cell[BoxData[
 RowBox[{"StreamPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{
      RowBox[{"-", "9.8"}], 
      RowBox[{"Sin", "[", "y", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7008746734672747`*^9, 3.700874684940283*^9}, {
  3.700875712445*^9, 3.7008757305240583`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Damped", " ", "Pendulum"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"StreamPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"v", ",", 
      RowBox[{
       RowBox[{"-", "v"}], "-", 
       RowBox[{"9.8", 
        RowBox[{"Sin", "[", "y", "]"}]}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"v", ",", 
      RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
    RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]}]], "Input",
 CellChangeTimes->{
  3.7008747124198823`*^9, {3.700874849831026*^9, 3.7008748555666733`*^9}}],

Cell[BoxData[
 RowBox[{"StreamPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{
      RowBox[{"-", "v"}], "-", 
      RowBox[{"9.8", 
       RowBox[{"Sin", "[", "y", "]"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "3"}], ",", "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "6"}], ",", "16"}], "}"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"StreamPoints", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "15"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7008751983960047`*^9, 3.700875295920519*^9}, {
  3.7008755807618217`*^9, 3.700875606347985*^9}}],

Cell[BoxData[
 RowBox[{"StreamPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{
      RowBox[{"-", "v"}], "-", 
      RowBox[{"9.8", 
       RowBox[{"Sin", "[", "y", "]"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "3"}], ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "6"}], ",", "21"}], "}"}], ",", 
   RowBox[{"Axes", "->", "True"}], ",", 
   RowBox[{"StreamPoints", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "5"}], "}"}], ",", "Red"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "10"}], "}"}], ",", "Green"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "15"}], "}"}], ",", "Orange"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "20"}], "}"}], ",", "Pink"}], "}"}], ",", 
       "Automatic"}], "}"}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7008753479850445`*^9, 3.700875464431778*^9}, {
   3.700875496162368*^9, 3.7008755333201866`*^9}, 3.700875619211915*^9}]
},
WindowSize->{1280, 941},
WindowMargins->{{-8, Automatic}, {Automatic, -8}},
FrontEndVersion->"10.2 for Microsoft Windows (64-bit) (July 29, 2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 203, 4, 31, "Input"],
Cell[764, 26, 537, 15, 31, "Input"],
Cell[1304, 43, 663, 17, 31, "Input"],
Cell[1970, 62, 157, 3, 31, "Input"],
Cell[2130, 67, 2913, 89, 77, "Input"],
Cell[5046, 158, 571, 16, 31, "Input"],
Cell[5620, 176, 88, 2, 31, "Input"],
Cell[5711, 180, 822, 27, 31, "Input"],
Cell[6536, 209, 668, 18, 31, "Input"],
Cell[7207, 229, 425, 14, 31, "Input"],
Cell[7635, 245, 102, 2, 31, "Input"],
Cell[7740, 249, 623, 20, 31, "Input"],
Cell[8366, 271, 652, 22, 31, "Input"],
Cell[9021, 295, 520, 16, 31, "Input"],
Cell[9544, 313, 642, 17, 31, "Input"],
Cell[10189, 332, 621, 18, 52, "Input"],
Cell[10813, 352, 548, 16, 31, "Input"],
Cell[11364, 370, 673, 20, 52, "Input"],
Cell[12040, 392, 858, 26, 31, "Input"],
Cell[12901, 420, 1261, 38, 52, "Input"]
}
]
*)

(* End of internal cache information *)
